unit FormOsoba;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Mask, Buttons;

type
  TFOsoba = class(TForm)
    btnAnuluj: TBitBtn;
    btnOK: TBitBtn;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    meNazwisko: TMaskEdit;
    meImie: TMaskEdit;
    meMcowosc: TMaskEdit;
    meUlicaINr: TMaskEdit;
    meKodp: TMaskEdit;
    meMiasto: TMaskEdit;
    mePesel: TMaskEdit;
    dtpDataUr: TDateTimePicker;
    procedure btnOKClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

  private
    procedure   Set_nazwisko();
    procedure   Set_imie();
    procedure   Set_dataur();
    procedure   Set_mcowosc();
    procedure   Set_ulicainr();
    procedure   Set_kodp();
    procedure   Set_miasto();
    procedure   Set_pesel();

    function    Get_nazwisko() : String;
    function    Get_imie() : String;
	 function    Get_dataur() : TDate;
    function    Get_mcowosc() : String;
    function    Get_ulicainr() : String;
    function    Get_kodp() : String;
    function    Get_miasto() : String;
    function    Get_pesel() : String;

  public
    procedure   Dodaj_rekord();
	 constructor Create(AOwner: TComponent); override;
  end;

var
  FOsoba: TFOsoba;

implementation

uses DataModule;
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TFOsoba.btnOKClick(Sender: TObject);
begin
   // wstawi rekord mozna tylko wtedy
   // gdy conajmniej
   // pola nazwisko i imi maj jakie wartoci

   if (Trim(meNazwisko.Text) <> '') and (Trim(meImie.Text) <> '') then
   begin
      Dodaj_rekord();
   end;
end;

constructor TFOsoba.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);

   Set_nazwisko();
   Set_imie();
   Set_dataur();
   Set_mcowosc();
   Set_ulicainr();
   Set_kodp();
   Set_miasto();
   Set_pesel();
end;

procedure TFOsoba.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TFOsoba.FormDestroy(Sender: TObject);
begin
  FOsoba := Nil;
end;

procedure TFOsoba.Set_nazwisko();
begin
   meNazwisko.Text := '';
end;

procedure TFOsoba.Set_imie();
begin
   meImie.Text := '';
end;

procedure TFOsoba.Set_dataur();
begin
   dtpDataUr.Date := Date();
end;

procedure TFOsoba.Set_mcowosc();
begin
   meMcowosc.Text := '';
end;

procedure TFOsoba.Set_ulicainr();
begin
   meUlicaINr.Text := '';
end;

procedure TFOsoba.Set_kodp();
begin
   meKodp.Text := '';
end;

procedure TFOsoba.Set_miasto();
begin
   meMiasto.Text := '';
end;

procedure TFOsoba.Set_pesel();
begin
   mePesel.Text := '';
end;

function TFOsoba.Get_nazwisko() : String;
begin
   Result := Trim(meNazwisko.Text);
end;

function TFOsoba.Get_imie() : String;
begin
   Result := Trim(meImie.Text);
end;

function TFOsoba.Get_dataur() : TDate;
begin
   Result := dtpDataUr.Date;
end;

function TFOsoba.Get_mcowosc() : String;
begin
   Result := Trim(meMcowosc.Text);
end;

function TFOsoba.Get_ulicainr() : String;
begin
   Result := Trim(meUlicaINr.Text);
end;

function TFOsoba.Get_kodp() : String;
begin
   Result := Trim(meKodp.Text);
end;

function TFOsoba.Get_miasto() : String;
begin
   Result := Trim(meMiasto.Text);
end;

function TFOsoba.Get_pesel() : String;
begin
   Result := Trim(mePesel.Text);
end;

procedure TFOsoba.Dodaj_rekord();
var
	sql_txt : String;
   isOK    : Boolean;
   
begin
   // metoda wykonywana po wciniciu klawisza OK
	// poniszy wiersz pomijamy bo pole jest typu autoincrement
   sql_txt := sql_txt + 'INSERT INTO  OSOBY( ';
   sql_txt := sql_txt + 'nazwisko, imie, mcowosc, dataur, ulicainr, kodp, miasto, pesel) ';
   sql_txt := sql_txt + 'VALUES(:nazwisko, :imie, :mcowosc, :dataur, :ulicainr, ';
   sql_txt := sql_txt + ':kodp, :miasto, :pesel)';

   DM.ADOCommand1.CommandText := sql_txt;

   DM.ADOCommand1.Parameters.ParamByName('nazwisko').Value := Get_nazwisko();
   DM.ADOCommand1.Parameters.ParamByName('imie').Value     := Get_imie();
   DM.ADOCommand1.Parameters.ParamByName('dataur').Value   := Get_dataur();
   DM.ADOCommand1.Parameters.ParamByName('mcowosc').Value  := Get_mcowosc();
   DM.ADOCommand1.Parameters.ParamByName('ulicainr').Value := Get_ulicainr();
   DM.ADOCommand1.Parameters.ParamByName('kodp').Value     := Get_kodp();
   DM.ADOCommand1.Parameters.ParamByName('miasto').Value   := Get_miasto();
   DM.ADOCommand1.Parameters.ParamByName('pesel').Value    := Get_pesel();

   isOK := true;
   try
      DM.ADOCommand1.Execute();
      {
		DM.ADODataSet1.Recordset := DM.ADOCommand1.Execute();
      }
	except
   	isOK := false;
      ShowMessage('Bd wykonania instrukcji ADOCommand.Execute');
   end;

   if isOK then
   begin
   	ShowMessage('Rekord dodany prawidowo');
   end;
end;

end.

